const sliderContainer = document.querySelector('.slider-container');
const sliderAfter = document.querySelector('.slider-after');
const sliderHandle = document.querySelector('.slider-handle');

sliderContainer.addEventListener('mousemove', function (e) {
    const containerRect = sliderContainer.getBoundingClientRect();
    const position = ((e.clientX - containerRect.left) / containerRect.width) * 100;

    sliderAfter.style.clipPath = `inset(0 ${100 - position}% 0 0)`;
    sliderHandle.style.left = `${position}%`;
});

sliderContainer.addEventListener('touchmove', function (e) {
    const touch = e.touches[0];
    const containerRect = sliderContainer.getBoundingClientRect();
    const position = ((touch.clientX - containerRect.left) / containerRect.width) * 100;

    sliderAfter.style.clipPath = `inset(0 ${100 - position}% 0 0)`;
    sliderHandle.style.left = `${position}%`;
});
